class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Daily Mail'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_before = dict(id='')
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['page-header bdrgr2','footer','page-footer','and-footer',
                                 'banner-adverts','column-content cleared','femail item','item','beta','articleAds',
                                 'article-icon-links-container','print-or-mail-links cleared','clear','explore-links',
                                    'form-inner bogr1','relatedItems','thinCenter','relatedItemsTop Border',
                                    'ro-header link-ccow','float-r hidden','floatRHS']}),
                   dict(name='div', attrs={'id':['reader-comments','lightbox-container','lightbox-target','pushdown-ad']}),
                   dict(name='ul', attrs={'style':['font-weight: bold;']}),
	dict(name='a', attrs={'class':['lightboxPopupLink']}),
	dict(name='p', attrs={'class':'imageCaption'}),
                   dict(name='img'),]

    remove_attributes = ['style', 'font']


    feeds          = [(u'News', u'http://www.dailymail.co.uk/news/index.rss'), 
                          (u'Sport', u'http://www.dailymail.co.uk/sport/index.rss'), 
                          (u'TV and Showbiz', u'http://www.dailymail.co.uk/tvshowbiz/index.rss'), 
                          (u'Health', u'http://www.dailymail.co.uk/health/index.rss'),
                          (u'Science and Tech', u'http://www.dailymail.co.uk/sciencetech/index.rss'), 
                          (u'Nutrition',u'http://www.dailymail.co.uk/health/directory/index.rss?healthTopic=8')
]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup


